% Get the eigenvectors
% Evolve wavefunction from initial point (lower triangle corner) to the
% measurement node
% ------------------------------------------------------------------------

function amp = get_g0_mech_cav(kpeak, scat, dis, tri, vel, g0peak)

% Eigenvectors
evec = zeros(2, size(kpeak.horz, 2));
evec(1,:) = 1;

sol_node = zeros(2, size(kpeak.horz, 2));

% Distance interpretation for translation operator evaluation
quo = floor(dis/(tri.L*tri.amech));
dis_last = rem(dis, tri.L*tri.amech);

% Define all the transfer matrices
T1 = transfer_matrix(scat.r1, scat.t1, 'usual');
T2 = transfer_matrix(scat.r2, scat.t2, 'usual');
T1m = transfer_matrix(scat.r1, scat.t1, 'mirror');

for i=1:size(kpeak.horz, 2)
    Twg2 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.slant(i)*tri.L*tri.amech);
    Twg3 = Twg2;
    Twg1 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.horz(i)*tri.L*tri.amech);
    
    % Transfer matrix for the whole round trip
    Ttri = Twg1*T1m*Twg3*T2*Twg2*T1;
    
    % Get eigenvectors
    evec(2,i) = (1 - Ttri(1,1))/Ttri(1,2);
    
    % Get normalization constant B
    Twg_mid2 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.slant(i)*tri.L*tri.amech/2);
    A2 = Twg_mid2*T1*evec(:,i);
    A2 = sum(abs(A2))/2;
    Twg_mid1 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.horz(i)*tri.L*tri.amech/2);
    A1 = Twg_mid1*T1m*Twg3*T2*Twg2*T1*evec(:,i);
    A1 = sum(abs(A1))/2;
    
    B = (2/3*(A1^2/vel.horz(i) + 2*A2^2/vel.slant(i)))^(-1/2);
    
    % Get signal amplitude at the measurement node
    if quo==0
        Twg2 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
            kpeak.slant(i)*dis_last);
        sol_node(:,i) = Twg2*T1*evec(:,i);
        
        prob = g0peak.slant(i)/sqrt(vel.slant(i))*...
            sum(abs(sol_node(:,i)))/2;
    elseif quo==1
        Twg3 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
            kpeak.slant(i)*dis_last);
        sol_node(:,i) = Twg3*T2*Twg2*T1*evec(:,i);
        
        prob = g0peak.slant(i)/sqrt(vel.slant(i))*...
            sum(abs(sol_node(:,i)))/2;
    else
        Twg1 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
            kpeak.horz(i)*dis_last);
        sol_node(:,i) = Twg1*T1m*Twg3*T2*Twg2*T1*evec(:,i);
        
        prob = g0peak.horz(i)/sqrt(vel.horz(i))*...
            sum(abs(sol_node(:,i)))/2;
    end

    amp(i) = abs(2*pi*B*prob*2*cos(angle(sol_node(2,i)/sol_node(1,i))/2));
   
    
%     disp(A2);
%     disp(sum(abs(sol_node(:,i)))/2);
end

% disp( ['Maximum absolute value of a component of the eigenvector: '...
%         , num2str(max(max(abs(evec))))]  );
% disp( ['Minimum absolute value of a component of the eigenvector: '...
%         , num2str(min(min(abs(evec))))]  );
%     
% disp( ['Maximum absolute value of a component at the measured node: '...
%     , num2str(max(max(abs(sol_node))))]  );
% disp( ['Minimum absolute value of a component at the measured node: '...
%         , num2str(min(min(abs(sol_node))))]  );

end